@echo off
:: ===========================================================
:: ITVDesk Cleanup Utility v2.1 (2025)
:: -----------------------------------------------------------
:: This tool safely stops ITVDesk and FFplay
:: processes, then immediately releases any blocked
:: RTSP/RTSPS/HTTP/ONVIF ports that Windows may still hold.
::
:: Background info:
:: On some Windows systems (especially Windows 10/11),
:: TCP ports may remain in the TIME_WAIT or CLOSE_WAIT state
:: for several minutes even after the process has exited.
:: This can prevent ITVDesk from restarting immediately.
::
:: This script forces full cleanup — terminating any
:: remaining processes and freeing all default ITVDesk ports.
::
:: Works best when run as Administrator.
:: ===========================================================

title ITVDesk Cleanup Utility
color 1F
mode con cols=90 lines=30

echo ===============================================
echo      ITVDesk Cleanup Utility v2.0 - (Admin)
echo ===============================================
echo.
echo   This will stop the following processes:
echo    - ITVDesk Pro IPCam - itvdesk.exe
echo    - Test stream tool - ffplay.exe
echo.
echo It will also clean all default ITVDesk ports:
echo    322, 554, 5554, 8554, 7000-7001, 8080, 443, 22000-22006
echo.
set /p USERCONFIRM="Do you want to continue? (Y/N): "

if /I NOT "%USERCONFIRM%"=="Y" (
    echo.
    echo Operation cancelled by user.
    echo ===============================================
    pause
    exit /b
)

:: Require administrator privileges
net session >nul 2>&1
if %errorLevel% NEQ 0 (
    echo Requesting administrator privileges...
    powershell -Command "Start-Process '%~f0' -Verb RunAs"
    exit /b
)

echo.
echo ===============================================
echo Shutting down active processes...
echo ===============================================

for %%P in (ITVDesk.exe ITVDeskWatcher.exe ffplay.exe) do (
    echo Checking for %%P ...
    tasklist /FI "IMAGENAME eq %%P" | find /I "%%P" >nul
    if !errorlevel! == 0 (
        echo   Killing %%P ...
        taskkill /F /IM %%P >nul 2>&1
    ) else (
        echo   %%P not running.
    )
)

echo.
echo Waiting 2 seconds for processes to fully terminate...
timeout /t 2 >nul

echo.
echo ===============================================
echo Cleaning blocked network ports...
echo ===============================================

setlocal enabledelayedexpansion

for %%P in (322 554 5554 8554 7000 7001 8080 22000 22001 22002 22003 22004 22005 22006) do (
    echo.
    echo Checking port %%P ...
    for /f "tokens=5" %%A in ('netstat -ano ^| findstr /R /C:":%%P[ ]"') do (
        echo   Killing PID %%A (port %%P)
        taskkill /F /PID %%A >nul 2>&1
    )
)

echo.
echo ===============================================
echo All done. ITVDesk environment cleaned.
echo ===============================================
pause
exit /b
